



#include <SPI.h>
#include "AD7190.h"
#include "uartdebug.h"


#define LED_ON digitalWrite(13,1)
#define LED_OFF digitalWrite(13,0)


// #define TEST_SIGNAL

char __print_line_buf[200];

void setup() {

	Serial.begin(115200);
	// Serial.println("Welcome to the AD7190 data bridge");
	// Serial.print("uartDbg('T'): ");
	// uartDbg('T');

	Serial.println();

	pinMode(13, OUTPUT); // LED
	pinMode(22, OUTPUT); // chipselect
	pinMode(74, INPUT); // MISO

	PRINT_LINE;

	uint8_t ret;

	do
	{
		ret = AD7190_Init();
		if (ret == 100) { // SPI_Init() failed
			PRINT_LINE;
		} else if (ret == 0) { // wrong ID
			PRINT_LINE;
		}
	}while(ret != 1);


	uint32_t confReg =
		AD7190_CONF_CHOP |   // chop enable (zero drift/offset)
		// AD7190_CONF_REFSEL |  // not set = using REF1 (Vref = AVDD)
		AD7190_CONF_REFSEL |  // set = using REF2 (Vref = 2.5V)
		AD7190_CONF_CHAN(1<<AD7190_CH_AIN3P_AIN4M) | 
		// AD7190_CONF_BURN  | do not use burn-currents
		// AD7190_CONF_REFDET | do not use reference detection
		AD7190_CONF_BUF | // enable analog input buffer
		// AD7190_CONF_UNIPOLAR | // using bipolar mode
		AD7190_CONF_GAIN(AD7190_CONF_GAIN_128); // Gain = 1 (Vin = max. +-Vref)


	uint32_t modeReg =
		AD7190_MODE_SEL(AD7190_MODE_CONT) | // continuous sampling
		// AD7190_MODE_DAT_STA | // no status byte tranmission after data
		AD7190_MODE_CLKSRC(AD7190_CLK_INT) | // using internal clock (4.92MHz +-4%)
		// AD7190_MODE_SINC3 | // using SINC4 filter
		// AD7190_MODE_ENPAR | // do not enable parity bit
		// AD7190_MODE_SCYCLE | // do not settle in one cycle
		// AD7190_MODE_REJ60 | // do net reject 60Hz
		AD7190_MODE_RATE(2); // samplerate = 1200/2 = 600 S/s with SINC4 filter and chopping

  // write register-values to the chip:

	ADI_PART_CS_LOW;
	AD7190_SetRegisterValue(AD7190_REG_CONF, confReg, 3, 0);
	ADI_PART_CS_HIGH;

	// sprintf(__print_line_buf, "confReg = 0x%x\n", confReg);
	// print(__print_line_buf);

	ADI_PART_CS_LOW;
	confReg = AD7190_GetRegisterValue(AD7190_REG_CONF, 3, 0);
	ADI_PART_CS_HIGH;

	//  	sprintf(__print_line_buf, "readback confReg = 0x%x\n", confReg);
	// print(__print_line_buf);



	ADI_PART_CS_LOW;
	AD7190_SetRegisterValue(AD7190_REG_MODE, modeReg, 3, 0);
	ADI_PART_CS_HIGH;

	//  	sprintf(__print_line_buf, "modeReg = 0x%x\n", modeReg);
	// print(__print_line_buf);

	ADI_PART_CS_LOW;
	modeReg = AD7190_GetRegisterValue(AD7190_REG_MODE, 3, 0);
	ADI_PART_CS_HIGH;

	//  	sprintf(__print_line_buf, "readback modeReg = 0x%x\n", modeReg);
	// print(__print_line_buf);


	ADI_PART_CS_LOW;
	AD7190_SetRegisterValue(AD7190_REG_GPOCON, 1<<6 , 1, 0); // enable BPDSW, bridge power down switch
	ADI_PART_CS_HIGH;

	digitalWrite(74, HIGH); // turn on pullup for MISO
	ADI_PART_CS_LOW;   
}

void loop() {
	uint8_t dataR[3] = {0};
	pinMode(74, INPUT); // MISO
	while(AD7190_RDY_STATE); // wenn MISO-Leitung auf Low geht -> Sample fertig zum Abholen.
	
	// start continuous read command:
	uint8_t data = 0x58; // single read data
	mySPI_Write(0, &data, 1);
	mySPI_Read(0, dataR, 3);
	uint32_t value = dataR[0]*256*256 + dataR[1]*256 + dataR[2];

	int64_t v = value; // copy to 64-bit to remove offset

	if(TEST_SIGNAL)
	{
		const double scale = 4.6566129e-9/5.0*2.5; // V/LSB
		const double f = 77; // Freuquenz in Hz
		const double A = 1e-3; // Amplitued in V
		static int n=0;
		v = A*sin(2.0*M_PI*77.0*(n++)/600.0) / scale;
		Serial.println(int32_t(v));		
	}else
	{
		v-=8388608; // remove offset
		Serial.println(int32_t(v));
	}
}


void print(const char* str)
{
  Serial.print(str);
}

